/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.core.living;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.core.living.LivingStats;

public interface ILivingContainer {
    default public LivingStats getLivingStats(ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_("livingStats")) {
            return null;
        }
        return LivingStats.fromNBT(stack.m_41783_().m_128469_("livingStats"));
    }

    default public void updateLivingStats(ItemStack stack, LivingStats stats) {
        if (stats == null) {
            if (stack.m_41782_()) {
                stack.m_41783_().m_128473_("livingStats");
            }
            return;
        }
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41783_().m_128365_("livingStats", (Tag)stats.serialize());
    }

    public static void setDisplayIfZero(ItemStack stack, boolean doDisplay) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41783_().m_128379_("displayIfLevelZero", doDisplay);
    }

    public static boolean displayIfLevelZero(ItemStack stack) {
        if (stack.m_41782_()) {
            return stack.m_41783_().m_128471_("displayIfLevelZero");
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void appendLivingTooltip(ItemStack stack, LivingStats stats, List<Component> tooltip, boolean trainable) {
        if (stats != null) {
            if (trainable) {
                tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.livingarmour.upgrade.points", new Object[]{stats.getUsedPoints(), stats.getMaxPoints()}).m_130940_(ChatFormatting.GOLD));
            }
            stats.getUpgrades().forEach((k, v) -> {
                if (k.getLevel(v.intValue()) <= 0 && !ILivingContainer.displayIfLevelZero(stack)) {
                    return;
                }
                boolean sneaking = Screen.m_96638_();
                if (!sneaking || k.getNextRequirement(v.intValue()) == 0) {
                    int level = k.getLevel(v.intValue());
                    if (level > 0) {
                        tooltip.add((Component)new TranslatableComponent("%s %s", new Object[]{new TranslatableComponent(k.getTranslationKey()), new TranslatableComponent("enchantment.level." + level)}).m_130940_(ChatFormatting.GRAY));
                    } else {
                        tooltip.add((Component)new TranslatableComponent(k.getTranslationKey()).m_130940_(ChatFormatting.GRAY));
                    }
                } else {
                    tooltip.add((Component)new TranslatableComponent("%s %s", new Object[]{new TranslatableComponent(k.getTranslationKey()), ": " + v.intValue() + "/" + k.getNextRequirement(v.intValue())}).m_130940_(ChatFormatting.GRAY));
                }
            });
        }
    }
}

